/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.ws;

import filenet.vw.api.VWSession;
import filenet.vw.api.VWWorkflowSignature;
import filenet.vw.base.VWDebug;
import filenet.vw.base.VWUDDIRegistry;
import filenet.vw.base.VWUDDIRegistryList;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.ws.VWUDDIAuthenticationDialog;
import filenet.vw.toolkit.utils.ws.VWUDDIBusinessNameDialog;
import filenet.vw.toolkit.utils.ws.VWWSWorkflow;
import filenet.vw.toolkit.utils.ws.base.IVWUDDIEventListener;
import filenet.vw.toolkit.utils.ws.base.VWUDDIBusinessItem;
import filenet.vw.toolkit.utils.ws.base.VWUDDIEvent;
import filenet.vw.toolkit.utils.ws.base.VWUDDIRegistryItem;
import filenet.ws.api.uddi.WSUDDIUtils;
import filenet.ws.utils.WSPublishToUDDI;
import filenet.ws.utils.WSValidateServerCertificate;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.juddi.datatype.Name;
import org.apache.juddi.datatype.business.BusinessEntity;
import org.apache.juddi.error.RegistryException;

public class VWUDDIRegistryManager
implements ChangeListener {
    public static int UDDI_AUTHENTICATE_CANCEL = 0;
    public static int UDDI_AUTHENTICATE_SUCCESS = 1;
    public static int UDDI_AUTHENTICATE_FAILED = 2;
    private VWSession m_session = null;
    private VWUDDIRegistryList m_vwRegistryList = null;
    private VWUDDIRegistry[] m_vwUDDIRegistries = null;
    private VWUDDIRegistryItem[] m_vwUDDIRegistryItems = null;
    private VWUDDIRegistry[] m_untrustedSites = null;
    private boolean m_bUddiRegistryPropertyModified = false;
    private boolean m_bAbortInit = false;
    private boolean m_bPublishCanceled = false;
    private Vector m_changeListeners = new Vector();
    private Vector m_publishListeners = new Vector();

    public static String _get_FILE_DATE() {
        return "$Date:   10 Sep 2008 09:15:54  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ysoong  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.10  $";
    }

    VWUDDIRegistryManager(VWSession session, VWUDDIRegistryList vwUDDIRegistryList) {
        this.m_session = session;
        this.m_vwRegistryList = vwUDDIRegistryList;
    }

    public VWUDDIRegistryList getUDDIRegistryList() {
        return this.m_vwRegistryList;
    }

    public VWUDDIRegistryItem[] getUDDIRegistryItemList() {
        return this.m_vwUDDIRegistryItems;
    }

    public VWSession getVWSession() {
        return this.m_session;
    }

    public void deleteBusiness(VWUDDIRegistryItem registry, boolean bSaveRegInfo) {
        if (registry != null) {
            int iProgress = 0;
            String businessName = registry.getBusinessName();
            this.fireUDDIEvent(businessName, 1, 0, null, iProgress++);
            this.fireUDDIEvent(businessName, 2, 0, VWResource.s_ellipse.toString(VWResource.s_deleteBusiness), iProgress++);
            VWUDDIRegistry vwRegistry = registry.getVWUDDIRegistry();
            if (vwRegistry != null) {
                vwRegistry.removeBusiness(businessName);
                this.m_bUddiRegistryPropertyModified = true;
                this.fireUDDIEvent(businessName, 2, 0, VWResource.s_ellipse.toString("update registry"), iProgress++);
                if (bSaveRegInfo) {
                    this.saveRegistryInfo();
                }
                this.fireUDDIEvent(businessName, 3, 1, null, iProgress++);
            }
            this.fireUDDIEvent(businessName, 4, 4, null, iProgress++);
        }
    }

    public void setBusinessKey(VWUDDIRegistryItem registry, String key) {
        VWUDDIRegistry vwRegistry;
        if (registry != null && (vwRegistry = registry.getVWUDDIRegistry()) != null) {
            vwRegistry.setBusinessKey(key);
            this.m_bUddiRegistryPropertyModified = true;
        }
    }

    public void setBusinessName(VWUDDIRegistryItem registry, String name) {
        VWUDDIRegistry vwRegistry;
        if (registry != null && (vwRegistry = registry.getVWUDDIRegistry()) != null) {
            vwRegistry.setBusinessName(name);
            this.m_bUddiRegistryPropertyModified = true;
        }
    }

    public void setBusinessNameVector(VWUDDIRegistryItem registry, Vector name) {
        VWUDDIRegistry vwRegistry;
        if (registry != null && (vwRegistry = registry.getVWUDDIRegistry()) != null) {
            vwRegistry.setBusinessNameVector(name);
            this.m_bUddiRegistryPropertyModified = true;
        }
    }

    public void setBusinessDescription(VWUDDIRegistryItem registry, String description) {
        VWUDDIRegistry vwRegistry;
        if (registry != null && (vwRegistry = registry.getVWUDDIRegistry()) != null) {
            vwRegistry.setBusinessDescription(description);
            this.m_bUddiRegistryPropertyModified = true;
        }
    }

    public void setBusinessDescriptionVector(VWUDDIRegistryItem registry, Vector description) {
        VWUDDIRegistry vwRegistry;
        if (registry != null && (vwRegistry = registry.getVWUDDIRegistry()) != null) {
            vwRegistry.setBusinessDescriptionVector(description);
            this.m_bUddiRegistryPropertyModified = true;
        }
    }

    public void setAuthorizedUsername(VWUDDIRegistryItem registry, String username) {
        VWUDDIRegistry vwRegistry;
        if (registry != null && (vwRegistry = registry.getVWUDDIRegistry()) != null) {
            vwRegistry.setAuthorizedUsername(username);
            this.m_bUddiRegistryPropertyModified = true;
        }
    }

    public void setPublishUserName(VWUDDIRegistryItem registry, String username) {
        VWUDDIRegistry vwRegistry;
        if (registry != null && (vwRegistry = registry.getVWUDDIRegistry()) != null) {
            vwRegistry.setPublishUsername(username);
            this.m_bUddiRegistryPropertyModified = true;
        }
    }

    public void saveRegistryInfo() {
        if (this.m_bUddiRegistryPropertyModified) {
            this.m_vwRegistryList.saveAndCommit(this.m_session);
        }
        this.m_bUddiRegistryPropertyModified = false;
    }

    protected void initData(Container container) throws Exception {
        if (this.m_vwRegistryList != null) {
            this.m_vwUDDIRegistries = this.m_vwRegistryList.getUDDIRegistries();
            WSValidateServerCertificate validateCert = new WSValidateServerCertificate();
            if (this.m_vwUDDIRegistries != null && this.m_vwUDDIRegistries.length > 0) {
                Vector<VWUDDIRegistry> v = new Vector<VWUDDIRegistry>();
                this.m_vwUDDIRegistryItems = new VWUDDIRegistryItem[this.m_vwUDDIRegistries.length];
                for (int i = 0; i < this.m_vwUDDIRegistries.length; ++i) {
                    String urlString;
                    if (this.m_bAbortInit) {
                        return;
                    }
                    if (this.m_vwUDDIRegistries[i] == null) {
                        return;
                    }
                    this.m_vwUDDIRegistryItems[i] = null;
                    int eventStatus = 0;
                    if (!this.m_vwUDDIRegistries[i].getPublish() || (urlString = this.m_vwUDDIRegistries[i].getPublishURL()) == null || urlString.length() == 0) continue;
                    String[] urls = new String[]{urlString};
                    boolean[] validated = validateCert.validateServers(urls);
                    Exception[] exceptions = validateCert.getValidateServerExceptions();
                    if (exceptions != null && exceptions.length > 0 && exceptions[0] != null) {
                        this.displayError(container, this.m_vwUDDIRegistries[i], exceptions[0]);
                        this.m_vwUDDIRegistryItems[i] = new VWUDDIRegistryItem(this.m_vwUDDIRegistries[i]);
                        this.m_vwUDDIRegistryItems[i].setState(2);
                        eventStatus = 2;
                        v.add(this.m_vwUDDIRegistries[i]);
                    }
                    if (validated[0]) {
                        if (this.m_vwUDDIRegistries[i] != null && this.m_vwUDDIRegistries[i].getPublish() && validated[0]) {
                            this.m_vwUDDIRegistryItems[i] = new VWUDDIRegistryItem(this.m_vwUDDIRegistries[i]);
                        }
                        this.m_vwUDDIRegistryItems[i].addChangeListener(this);
                        this.m_vwUDDIRegistryItems[i].setState(1);
                        eventStatus = 1;
                    } else {
                        v.add(this.m_vwUDDIRegistries[i]);
                        eventStatus = 2;
                    }
                    if (this.m_vwUDDIRegistryItems[i] == null) continue;
                    VWUDDIEvent uddiEvent = new VWUDDIEvent(this.m_vwUDDIRegistryItems[i], 5, eventStatus, null, i);
                    ChangeEvent event = new ChangeEvent(uddiEvent);
                    this.notifyChangeListener(event);
                }
                if (this.m_bAbortInit) {
                    return;
                }
                if (v != null && v.size() > 0) {
                    this.m_untrustedSites = new VWUDDIRegistry[v.size()];
                    v.toArray(this.m_untrustedSites);
                } else {
                    this.m_untrustedSites = null;
                }
            }
        }
    }

    public void setAbortInit(boolean bAbort) {
        this.m_bAbortInit = bAbort;
    }

    public int authenticate(Container parent, VWUDDIRegistryItem registryItem) {
        int authenticateStatus = UDDI_AUTHENTICATE_FAILED;
        if (registryItem != null && registryItem.getPublish()) {
            String username = registryItem.getVWUDDIRegistry().getPublishUsername();
            if (username != null && username.length() == 0) {
                username = null;
            }
            if (registryItem.isAuthenticated()) {
                authenticateStatus = UDDI_AUTHENTICATE_SUCCESS;
                if (username == null) {
                    registryItem.getVWUDDIRegistry().setPublishUsername(registryItem.getLogonUser());
                    this.m_bUddiRegistryPropertyModified = true;
                }
            } else {
                Dialog dialog = null;
                if (parent != null) {
                    if (parent instanceof Frame) {
                        dialog = new VWUDDIAuthenticationDialog((Frame)parent, username, registryItem.getWSUDDIRegistry());
                    } else if (parent instanceof Dialog) {
                        dialog = new VWUDDIAuthenticationDialog((Dialog)parent, username, registryItem.getWSUDDIRegistry());
                    }
                }
                if (dialog != null) {
                    dialog.setVisible(true);
                    if (((VWUDDIAuthenticationDialog)dialog).isCanceled()) {
                        this.m_bUddiRegistryPropertyModified = false;
                        authenticateStatus = UDDI_AUTHENTICATE_CANCEL;
                    } else if (registryItem.isAuthenticated()) {
                        authenticateStatus = UDDI_AUTHENTICATE_SUCCESS;
                        String logonUser = ((VWUDDIAuthenticationDialog)dialog).getUsername();
                        registryItem.setLogonUser(logonUser);
                        if (username == null) {
                            username = ((VWUDDIAuthenticationDialog)dialog).getUsername();
                            registryItem.getVWUDDIRegistry().setPublishUsername(logonUser);
                            this.m_bUddiRegistryPropertyModified = true;
                        }
                    }
                }
            }
        }
        return authenticateStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public VWUDDIBusinessItem publishBusiness(Frame parent, VWUDDIRegistryItem registryItem) throws Exception {
        String businessName = registryItem.getBusinessName();
        String businessKey = registryItem.getVWUDDIRegistry().getBusinessKey();
        if (businessKey != null && businessKey.length() == 0) {
            businessKey = null;
        }
        if (businessName != null && businessName.length() == 0) {
            businessName = null;
        }
        VWUDDIBusinessItem vwBusinessItem = null;
        if (businessKey != null) {
            try {
                Name name;
                vwBusinessItem = registryItem.findBusinessItemByKey(businessKey);
                if (vwBusinessItem == null) {
                    int result = 0;
                    if (parent != null) {
                        result = JOptionPane.showConfirmDialog(parent, VWResource.s_publishKeyNotFindWarning.toString(businessKey), VWResource.s_publish, 0);
                    }
                    if (result != 0) {
                        this.fireUDDIEvent("", 4, 6, null, 0);
                        return null;
                    }
                    this.setBusinessKey(registryItem, "");
                }
                if ((vwBusinessItem = registryItem.getVWBusinessItem()) != null && (name = vwBusinessItem.getName(0)) != null && VWStringUtils.compare(name.getValue(), businessName) != 0) {
                    this.setBusinessName(registryItem, name.getValue());
                    businessName = name.getValue();
                }
            }
            catch (Exception ex) {
                String msg = ex.getLocalizedMessage();
                if (msg == null || msg.length() <= 0) {
                    msg = ex.toString();
                }
                vwBusinessItem = null;
                this.showMessage(parent, VWResource.s_publishing, VWResource.s_error, 1, ex);
                VWDebug.logException(ex);
                this.fireUDDIEvent("", 3, 2, msg, 0);
                this.fireUDDIEvent("", 4, 5, null, 0);
                return null;
            }
        }
        if (vwBusinessItem == null) {
            VWUDDIBusinessNameDialog dialog;
            if (parent != null && (dialog = new VWUDDIBusinessNameDialog(parent, registryItem)) != null) {
                dialog.setVisible(true);
                if (dialog.isCanceled()) {
                    this.fireUDDIEvent("", 4, 6, VWResource.s_publishCanceled, 0);
                    return null;
                }
                businessName = dialog.getBusinessName();
                this.setBusinessName(registryItem, businessName);
                this.setBusinessDescription(registryItem, dialog.getBusinessDescription());
            }
            if (businessName == null) {
                String msg = VWResource.s_missingBusinessNameForUDDIRegistry.toString(registryItem.getName());
                this.showMessage(parent, msg, VWResource.s_publishing, 1);
                this.fireUDDIEvent("", 3, 2, msg, 0);
                this.fireUDDIEvent("", 4, 5, null, 0);
                return null;
            }
            vwBusinessItem = registryItem.getVWBusinessItem();
        }
        this.fireUDDIEvent(businessName, 1, 0, null, 0);
        this.fireUDDIEvent(businessName, 2, 0, VWResource.s_ellipse.toString(VWResource.s_authentication), 0);
        String username = registryItem.getVWUDDIRegistry().getPublishUsername();
        if (username != null && username.length() == 0) {
            username = null;
        }
        if (this.authenticate(parent, registryItem) != UDDI_AUTHENTICATE_SUCCESS) {
            this.fireUDDIEvent("", 3, 2, VWResource.s_unauthorizedUser, 0);
            this.fireUDDIEvent("", 4, 5, null, 0);
            return null;
        }
        this.fireUDDIEvent(businessName, 2, 0, VWResource.s_ellipse.toString(VWResource.s_publishBusiness), 1);
        String statusString = new String();
        Cursor currentCursor = null;
        try {
            block26: {
                try {
                    if (parent != null) {
                        currentCursor = parent.getCursor();
                        parent.setCursor(Cursor.getPredefinedCursor(3));
                    }
                    WSPublishToUDDI publishToUDDI = new WSPublishToUDDI(this.m_session);
                    BusinessEntity uddiBusinessEntity = publishToUDDI.publishBusiness(registryItem.getVWUDDIRegistry(), registryItem.getWSUDDIRegistry(), vwBusinessItem.getWSBusinessEntity());
                    this.fireUDDIEvent(businessName, 2, 0, VWResource.s_ellipse.toString(VWResource.s_refresh), 2);
                    if (uddiBusinessEntity == null) break block26;
                    String key = uddiBusinessEntity.getBusinessKey();
                    if (VWStringUtils.compare(businessKey, key) != 0) {
                        if (!vwBusinessItem.getWSBusinessEntity().hasBusinessKey()) {
                            vwBusinessItem.getWSBusinessEntity().setBusinessEntity(uddiBusinessEntity);
                        }
                        this.setBusinessKey(registryItem, key);
                        this.setPublishUserName(registryItem, registryItem.getLogonUser());
                    }
                    this.setBusinessNameVector(registryItem, uddiBusinessEntity.getNameVector());
                    this.setBusinessDescriptionVector(registryItem, uddiBusinessEntity.getDescriptionVector());
                    this.saveRegistryInfo();
                    registryItem.refresh();
                    this.fireUDDIEvent(businessName, 2, 0, null, 3);
                    String aName = null;
                    Vector v = uddiBusinessEntity.getNameVector();
                    if (v != null && v.size() > 0 && v.elementAt(0) != null && v.elementAt(0) instanceof Name) {
                        aName = ((Name)v.elementAt(0)).getValue();
                    }
                    statusString = VWResource.s_businessPublishedSuccessfully.toString(aName);
                    if (parent != null) {
                        this.showMessage(parent, statusString, VWResource.s_publish, 2);
                    }
                    this.fireUDDIEvent(businessName, 3, 1, statusString, 4);
                    this.fireUDDIEvent(businessName, 4, 4, null, 4);
                }
                catch (Exception ex) {
                    String errMsg = ex.getLocalizedMessage();
                    if (!(errMsg != null && errMsg.length() > 0 || (errMsg = ex.getMessage()) != null && errMsg.length() > 0)) {
                        errMsg = ex.toString();
                    }
                    statusString = VWResource.s_failedToPublishBusiness.toString(businessName, errMsg);
                    this.showMessage(parent, statusString, VWResource.s_publish, 2);
                    VWDebug.logException(ex);
                    this.fireUDDIEvent("", 3, 2, statusString, 1);
                    this.fireUDDIEvent("", 4, 5, null, 1);
                    vwBusinessItem = null;
                    Object var15_23 = null;
                    if (parent == null) return vwBusinessItem;
                    if (currentCursor == null) return vwBusinessItem;
                    parent.setCursor(currentCursor);
                    return vwBusinessItem;
                }
            }
            Object var15_22 = null;
            if (parent == null) return vwBusinessItem;
            if (currentCursor == null) return vwBusinessItem;
            parent.setCursor(currentCursor);
            return vwBusinessItem;
        }
        catch (Throwable throwable) {
            Object var15_24 = null;
            if (parent == null) throw throwable;
            if (currentCursor == null) throw throwable;
            parent.setCursor(currentCursor);
            throw throwable;
        }
    }

    public void setPublishCanceled(boolean b) {
        this.m_bPublishCanceled = b;
    }

    public void publishService(Frame parent, VWUDDIRegistryItem registryItem, VWWSWorkflow[] workflows) throws Exception {
        int publishStatus;
        this.m_bPublishCanceled = false;
        VWUDDIBusinessItem businessItem = null;
        String businessKey = registryItem.getVWUDDIRegistry().getBusinessKey();
        if (businessKey == null || businessKey.length() <= 0) {
            businessItem = this.publishBusiness(parent, registryItem);
        } else {
            try {
                businessItem = registryItem.findBusinessItemByKey(businessKey);
            }
            catch (Exception ex) {
                String statusString = ex.getLocalizedMessage();
                if (statusString == null || statusString.length() <= 0) {
                    statusString = ex.toString();
                }
                businessItem = null;
                this.showMessage(parent, VWResource.s_publishing, VWResource.s_error, 1, ex);
                this.fireUDDIEvent(workflows[0].getName(), 3, 2, statusString, 0);
                this.fireUDDIEvent(workflows, 4, 5, null, 0);
                return;
            }
        }
        if (this.authenticate(parent, registryItem) != UDDI_AUTHENTICATE_SUCCESS) {
            this.fireUDDIEvent(workflows[0].getName(), 3, 2, VWResource.s_unauthorizedUser, 0);
            this.fireUDDIEvent(workflows, 4, 5, VWResource.s_unauthorizedUser, 0);
            return;
        }
        String name = null;
        VWWorkflowSignature workflowSignature = null;
        WSPublishToUDDI workflowToUDDI = null;
        int failedCount = 0;
        int successCount = 0;
        int i = 0;
        while (!this.m_bPublishCanceled && workflows != null && i < workflows.length) {
            if (workflows[i] == null) {
                ++i;
                continue;
            }
            workflowSignature = workflows[i].getWorkflowSignature();
            String workflowName = workflows[i].getName();
            this.fireUDDIEvent(workflowName, 1, 0, null, i);
            String statusString = VWResource.s_workflowPublishedSuccessfully.toString(name);
            publishStatus = 1;
            if (workflowSignature != null) {
                name = workflowSignature.getName();
                try {
                    workflowToUDDI = new WSPublishToUDDI(this.m_session);
                    workflowToUDDI.publishService(registryItem.getVWUDDIRegistry(), registryItem.getWSUDDIRegistry(), businessItem.getWSBusinessEntity(), workflowSignature);
                    ++successCount;
                }
                catch (RegistryException ex) {
                    statusString = WSUDDIUtils.getErrMsg(ex);
                    publishStatus = 2;
                }
                catch (Exception ex) {
                    ++failedCount;
                    statusString = ex.getLocalizedMessage();
                    if (statusString == null || statusString.length() <= 0) {
                        statusString = ex.toString();
                    }
                    publishStatus = 2;
                }
            } else {
                publishStatus = 2;
                statusString = VWResource.s_noWorkflowSignature.toString(workflows[i].getName());
            }
            this.fireUDDIEvent(workflowName, 3, publishStatus, statusString, i);
            ++i;
        }
        this.fireUDDIEvent(registryItem.getBusinessName(), 2, 0, VWResource.s_ellipse.toString(VWResource.s_refresh), i);
        registryItem.refresh();
        this.fireUDDIEvent(registryItem.getBusinessName(), 2, 0, null, i + 1);
        publishStatus = i >= workflows.length ? 4 : 3;
        this.fireUDDIEvent(workflows, 4, publishStatus, null, i);
    }

    private void fireUDDIEvent(Object source, int eventType, int status, String message, int refCount) {
        if (this.m_publishListeners != null) {
            VWUDDIEvent evt = new VWUDDIEvent(source, eventType, status, message, refCount);
            for (int k = 0; k < this.m_publishListeners.size(); ++k) {
                ((IVWUDDIEventListener)this.m_publishListeners.get(k)).UDDIBusinessChanged(evt);
            }
        }
    }

    private void displayError(Container container, VWUDDIRegistry uddiRegistry, Exception ex) {
        if (uddiRegistry != null) {
            String msg = "\n" + uddiRegistry.getName() + "\n" + uddiRegistry.getPublishURL();
            this.showMessage(container, VWResource.s_failedToValidateServerCertificate.toString(msg), VWResource.s_error, 1, ex);
        }
    }

    private String showMessage(Container container, String msg, String title, int msgType) {
        return this.showMessage(container, msg, title, msgType, null);
    }

    private String showMessage(Container container, String msg, String title, int msgType, Exception ex) {
        if (ex != null) {
            msg = msg == null ? new String(ex.toString()) : msg + "\n" + ex.toString();
        }
        if (container instanceof Frame) {
            VWMessageDialog.showOptionDialog((Frame)container, msg, title, msgType);
        } else if (container instanceof JDialog) {
            VWMessageDialog.showOptionDialog((JDialog)container, msg, title, msgType);
        } else {
            JOptionPane.showMessageDialog(container, msg, title, msgType);
        }
        return msg;
    }

    public synchronized void addChangeListener(ChangeListener l) {
        if (this.m_changeListeners == null) {
            this.m_changeListeners = new Vector();
        }
        if (l != null && !this.m_changeListeners.contains(l)) {
            this.m_changeListeners.add(l);
        }
    }

    public synchronized void removeChangeListener(ChangeListener l) {
        if (this.m_changeListeners != null && l != null && this.m_changeListeners.contains(l)) {
            this.m_changeListeners.remove(l);
        }
    }

    public synchronized void addPublishListener(IVWUDDIEventListener l) {
        if (this.m_publishListeners == null) {
            this.m_publishListeners = new Vector();
        }
        if (l != null && !this.m_publishListeners.contains(l)) {
            this.m_publishListeners.add(l);
        }
    }

    public synchronized void removePublishListener(IVWUDDIEventListener l) {
        if (this.m_publishListeners != null && l != null && this.m_publishListeners.contains(l)) {
            this.m_publishListeners.remove(l);
        }
    }

    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (source instanceof VWUDDIRegistryItem) {
            this.notifyChangeListener(e);
        }
    }

    protected void notifyChangeListener(ChangeEvent evt) {
        if (this.m_changeListeners != null) {
            for (int i = 0; i < this.m_changeListeners.size(); ++i) {
                ((ChangeListener)this.m_changeListeners.get(i)).stateChanged(evt);
            }
        }
    }

    public BusinessEntity getRegionBusinessEntity() {
        if (this.m_vwRegistryList != null) {
            return this.m_vwRegistryList.getRegionBusinessEntity();
        }
        return null;
    }
}

